/**
 * Memory Analyser  version 1.00
 * Copyright (c) 2018, Tycho Veltmeijer.
 * All rights reserved.
**/

#include "Filter_Firefox.h"

/*Firefox Filter bevat 3 filters. Twee die zoekt naar URLS en een die zoekt naar Cookies, de filters staan beschreven in "3. Firefox".
Filter 1: URL's, beschreven in "3.1 URL's",  "Methode 1"
Filter 2: URL's, beschreven in "3.1 URL's",  "Methode 2"
Filter 3: Cookies, beschreven in "3.2 Cookies" */


/*--------------------------------------------------------Filter 1--------------------------------------------------------*/
DUMP_SESSION* InitiateFirefoxFilter1(char* location, char* argument, int analyse_type) {
	return CreateUNICODEMemoryDump(location, "Firefox_URL_Search_Methode1.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Zoekt in UNICODE-string naar URL's  (gebruik makend van handtekening 0x00000001)*/
int ApplyFirefoxFilter1(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	char signature[4]={0x01, 0x00, 0x00, 0x00}; //Een soort van signature waarmee een string mee begint in het geheugen van Firefox
	char* moveBuff=buff; //Positie in het geheugen waar de filter op dit moment bezig is
	wchar_t* moveBuff2; //Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behouden
	int writtenBytes; //Returnvalue van Writefile()
	int readSize=0;  //Tijdelijke parameter waar de grote van de string op wordt geplaatst.
	int isOkayURL=0; //Boolean waarde die Waar is indien de string een URL is en Onwaar indien de string geen URL bevat.
	int foundDot=0; //Boolean waarde, waar indien een punt is gevonden in de string, Onwaar indien er geen punt in voor komt

	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			if(memcmp(moveBuff, signature, 4) == 0) { //Klopt de handtekening van een string
				moveBuff+=4; //Zet pointer 4 bytes verder, hier staat de grote van de string die daarop volgt
				readSize = (int) *moveBuff; //Lees de lengte uit
				moveBuff+=4; //Zet de pointer op de string

				/*Zet de booleans op onwaar*/
				isOkayURL = 0; 
				foundDot=0;
				
				//Controleer of de lengte van de string klopt, of de lengte niet nul is en of de de string niet begint met "chrome://"
				if(wcslen((wchar_t*)moveBuff)*2==readSize-2 
					&& readSize!=0 
					&& memcmp(moveBuff, L"chrome://", 9*2) != 0) 
					isOkayURL = 1;

				moveBuff2=(wchar_t*) moveBuff;

				/*Controleer of het domein voldoet aan de eisen en bestaat uit:
				- Letters a - z
				- Cijfers 0-9
				- '-' of '.' */
				while(*moveBuff2 != 0) {
					if((*moveBuff2 < 'a' || *moveBuff2 > 'z') 
					&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
					&& *moveBuff2 != '-'
					&& *moveBuff2 != '.') {
						if(*moveBuff2 == ':' && *(moveBuff2+1) == '/' && *(moveBuff2+2) == '/') {//"://" is een protocol
							moveBuff2+=2;
						} else {
							if(*moveBuff2 == '/') //Hier loopt het domein af en begint de URL
								break;
							isOkayURL = 0;
							break;
						}
					} else {
						if(*moveBuff2 == '.')
							foundDot=1;
					}

					moveBuff2++;
				}

				if(foundDot==0)
					isOkayURL = 0;

				/*Controleer of de rest van de URL voldoet:
				- mag niet bestaan uit spatie (deze wordt aangeduid als %20
				-Mag niet bestaan uit een nieuwelijn (0D of 0A)
				*/
				while(*moveBuff2 != 0) {
					if(*moveBuff2 == ' ' || *moveBuff2 == 0x0D || *moveBuff2 == 0x0A) {
						isOkayURL = 0;
						break;
					}
					moveBuff2++;
				}

				/*We hebben een string gevonden en deze bevat een URL, schrijf deze weg, samen met het adres waarop deze gevonden is.*/
				if(isOkayURL) {
					if(dmp->flags&DS_WRITE_LOCATION_STRING) {
						printf("Address: %p: ",(memlong) memInfo->BaseAddress + (moveBuff - buff));
						wsprintfW((LPWSTR) dmp->string_location, L"Address: %p, \0", (memlong) memInfo->BaseAddress + (moveBuff - buff));
						WriteFile(dmp->dumpFile, dmp->string_location, wcslen((wchar_t*) dmp->string_location)*2, (LPDWORD) &writtenBytes, NULL);
					}

					wprintf(L"%s\r\n", moveBuff);
					WriteFile(dmp->dumpFile, moveBuff, wcslen((wchar_t*)moveBuff)*2, (LPDWORD) &writtenBytes, NULL);
					WriteFile(dmp->dumpFile, L"\r\n", 4, (LPDWORD) &writtenBytes, NULL);

					/*De gevonden string kunnen we overslaan, deze is immers al weggeschreven, we kunnen verder zoeken naar strings achter de gevonden string*/
					moveBuff += wcslen((wchar_t*)moveBuff) -1;
				} else {
					moveBuff-=7;
				}
			}
		}
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}
	return 0;
}

void DestroyFirefoxFilter1(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}

/*-----------------------------------------------------Einde Filter 1-----------------------------------------------------*/


/*--------------------------------------------------------Filter 2--------------------------------------------------------*/

DUMP_SESSION* InitiateFirefoxFilter2(char* location, char* argument, int analyse_type) {
	return CreateMemoryDump(location, "Firefox_URL_Search_Methode2.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}


/*Zoekt alle URL's waar heen is gesurft in de private sessie.*/
int ApplyFirefoxFilter2(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	/*In cmpBuffb staat de string 

		"HTTP-memory-only-PB:"

	hier begint elk adres mee waar naar toe is gesurft met een private sessie.
	*/
	char signature[20]={0x48, 0x54, 0x54, 0x50, 0x2D, 0x6D, 0x65, 0x6D, 0x6F, 0x72, 0x79, 0x2D, 0x6F, 0x6E, 0x6C, 0x79, 0x2D, 0x50, 0x42, 0x3A};
	char* moveBuff=buff; //Positie in het geheugen waar de filter op dit moment bezig is
	int writtenBytes; //Returnvalue van Writefile()
	int readSize=0;  //Tijdelijke parameter waar de grote van de string op wordt geplaatst.


	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			if(memcmp(moveBuff, signature,  20) == 0) { //We willen alleen adressen die beginnen met "HTTP-memory-only-PB:"
				/*Schrijf het adres weg waar de string gevonden is, indien nodig*/
				if(dmp->flags&DS_WRITE_LOCATION_STRING) {
					printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
					sprintf(dmp->string_location, "Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
					WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
				}

				moveBuff += 20; //Sla de string "HTTP-memory-only-PB:" over

				//Schrijf de gevonden URL weg
				printf("%s\n", moveBuff);
				WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL);
				WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

				//Verschuif de buffer om verder te zoeken
				moveBuff += strlen(moveBuff) -1;
			}
		}			
	} else {
		dmp->unlocated_size += memInfo->RegionSize;
	}
	return 0;
}


void DestroyFirefoxFilter2(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}
/*-----------------------------------------------------Einde Filter 2-----------------------------------------------------*/

/*--------------------------------------------------------Filter 3--------------------------------------------------------*/

DUMP_SESSION* InitiateFirefoxFilter3(char* location, char* argument, int analyse_type) {
	return CreateMemoryDump(location, "Firefox_Cookie_Search.txt", 0, 
		(argument==(char*) -1 ? DS_WRITE_LOCATION_STRING : strtol(argument, NULL, 10))
	);
}

/*Deze routine zoekt naar cookies in het geheugen (van firefox), schrijft de naam weg naar het console en overige informatie naar een text bestand*/
int ApplyFirefoxFilter3(DUMP_SESSION* dmp, HANDLE process, MEMORY_BASIC_INFORMATION* memInfo, char* buff, SIZE_T overflowSize) {
	int writtenBytes; //Returnvalue van Writefile()
	int isOkayURL; //Boolean waarde die Waar is indien de string een URL is en Onwaar indien de string geen URL bevat.
	char* moveBuff=buff; //Positie in het geheugen waar de filter op dit moment bezig is
	char* moveBuff2; //Zelfde als moveBuff, echter  wordt op deze manier de orginele positie behouden

	long long validUntil=0; //De tijd tot wanneer het cookie geldig is, in seconden vanaf 1970
	struct tm* valid_Until_Struct;  //De tijd tot wanneer het cookie geldig is
	struct tm *loctime; //De tijd tot wanneer het cookie geldig is, in de huidige tijdzone

	char signature1[2]={0x98, 0xFE}; //Signature of a Cookie 19.0.2
	char signature2[2]={0x40, 0x07}; //Signature of a Cookie 21.0.0
	


	if(memInfo->State!=MEM_FREE && memInfo->State!=MEM_RESERVE) {
		for(; moveBuff<(buff + memInfo->RegionSize); moveBuff++) {
			if((
				memcmp(moveBuff, signature1, 2) == 0 //Is het de 'handtekening' van een cookie
				|| memcmp(moveBuff, signature2, 2) == 0
				)
			&& overflowSize - ((memlong)moveBuff- (memlong)buff) > 0x40) { //Header van cookie is 0x40 bytes
				moveBuff2 = moveBuff;
				moveBuff2+=0x40;
				if(strlen(moveBuff2)!=0) { //Controleer of de cookienaam > 0 bytes
					moveBuff2+=strlen(moveBuff2)+1; //Zet pointer op waarde
					moveBuff2+=strlen(moveBuff2)+1; //Zet pointer op het Domein
					if(strlen(moveBuff2)!=0) { //Controleer of domein > 0 bytes

						/*Controleer of het domein voldoet aan de eisen en bestaat uit:
						- Letters a - z
						-cijfers 0-9
						- - of . */
						isOkayURL = 1;
						while(*moveBuff2 != 0) {
							if((*moveBuff2 < 'a' || *moveBuff2 > 'z') 
								&& (*moveBuff2 < '0' || *moveBuff2 > '9') 
								&& *moveBuff2 != '-'
								&& *moveBuff2 != '.') {
									isOkayURL = 0;
									break;
							}
							moveBuff2++;
						}

						/*Domeinnaam controlle klaar*/
							
						moveBuff2++; //Zet de pointer op de locatie vaan de cookie geldig is
						if(*moveBuff2!='/') //De locatie begint altijd met een slash
							isOkayURL=0;
							
						//Zijn alle controlles positief afgerond, dan is dit stuk geheugen een cookie
						if(isOkayURL==1) { 

							//Lees qword (64 bit) uit met daarop de 't/m geldigsheiddatum' in seconden vanaf 1970 en zet deze om in in GMT en GMT+locale tijd
							valid_Until_Struct = (struct tm*) malloc(sizeof(struct tm));
							loctime =  (struct tm*) malloc(sizeof(struct tm));
							memcpy(&validUntil, moveBuff+0x20, 8);
							memcpy(valid_Until_Struct, gmtime((time_t*) validUntil), sizeof(struct tm));
							localtime_s (loctime, &validUntil);

							/*Lees uit en schrijf weg:
							-Cookienaam
							-Cookie waarde
							-Verloopt op datum, in vorm: hh:mm:ss dd-mm-yyyy
							-Verloop op datum in lokale tijd (verrekend met zomertijd en tijdszone)
							-Domein waarop de cookie geldig is
							-URL op de domein waar de cookie geldig is
							*/

							if(dmp->flags&DS_WRITE_LOCATION_STRING) {
								printf("Address: %p: ", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								sprintf(dmp->string_location, "Address: %p\r\n", (memlong) memInfo->BaseAddress + (moveBuff - buff));
								WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
							}

							moveBuff+=0x40;
							printf("Cookie: %s \n", moveBuff);//Cookienaam in console

							//Cookienaam
							WriteFile(dmp->dumpFile, "naam: ", strlen("naam: "), (LPDWORD) &writtenBytes, NULL); 
							WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL); 

							//Cookiewaarde
							WriteFile(dmp->dumpFile, "\r\nwaarde: ", strlen("\r\nwaarde: "), (LPDWORD) &writtenBytes, NULL);
							moveBuff+=strlen(moveBuff)+1; //Zet pointer op cookie waarde
							WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL);

							//Verloopt op
							WriteFile(dmp->dumpFile, "\r\nVerloopt op: ", strlen("\r\nVerloopt op: "), (LPDWORD) &writtenBytes, NULL);

							if(validUntil==0x7FFFFFFFFFFFFFFF)
								sprintf(dmp->string_location, "Na deze sessie\r\n");
							else
								sprintf(dmp->string_location, "%hu:%hu:%hu %hu-%hu-%hu\r\n", 
									valid_Until_Struct->tm_hour,
									valid_Until_Struct->tm_min,
									valid_Until_Struct->tm_sec,
									valid_Until_Struct->tm_mday,
									valid_Until_Struct->tm_mon+1,
									valid_Until_Struct->tm_year + 1900);
							WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);

							//Verloop op (in lokale tijd)
							if(validUntil!=0x7FFFFFFFFFFFFFFF) {
								WriteFile(dmp->dumpFile, "\r\nVerloopt op (lokaal): ", strlen("\r\nVerloopt op (lokaal): "), (LPDWORD) &writtenBytes, NULL);

								sprintf(dmp->string_location, "%hu:%hu:%hu %hu-%hu-%hu\r\n", 
										loctime->tm_hour,
										loctime->tm_min,
										loctime->tm_sec,
										loctime->tm_mday,
										loctime->tm_mon+1,
										loctime->tm_year + 1900);

								WriteFile(dmp->dumpFile, dmp->string_location, strlen(dmp->string_location), (LPDWORD) &writtenBytes, NULL);
							}

							//Domeinnaam
							moveBuff+=strlen(moveBuff)+1;
							WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, "\r\n", strlen("\r\n"), (LPDWORD) &writtenBytes, NULL);

							//Localtie op het domein
							moveBuff+=strlen(moveBuff)+1;
							WriteFile(dmp->dumpFile, moveBuff, strlen(moveBuff), (LPDWORD) &writtenBytes, NULL);
							WriteFile(dmp->dumpFile, "\r\n\r\n", strlen("\r\n\r\n"), (LPDWORD) &writtenBytes, NULL);

							//Geef het virtuele geheugen vrij
							free(valid_Until_Struct);
							free(loctime); 
						}
					}
				}
			}
		}				
	} else {
		//Als het geheugen niet leesbaar is hoeft er niets te gebeuren.
	}

	return 0;
}


void DestroyFirefoxFilter3(DUMP_SESSION* filter) {
	Destroy_MemoryDump(filter);
}
/*-----------------------------------------------------Einde Filter 3-----------------------------------------------------*/